#include "tcp.h"

scc(color1,color2,bltime)	/* set cursor colors */
int color1,color2,bltime;
{
	aedbf[0] = SCC;
	aedbf[1] = color1;
	aedbf[2] = color2;
	aedbf[3] = bltime;
	obyte(aedbf,4);
}

scp(ctype,constraint,plane)	/* set cursor parameter */
int ctype,constraint,plane;
{

	switch(ctype){

	case 'L' :	/* full screen T square cursor	*/
	case '+' :	/* "+" shaped cursor	*/
	case 'X' :	/* "X" shaped cursor	*/

		aedbf[0] = SCP;
		aedbf[1] = ctype;	
		aedbf[2] = constraint & 127;
		aedbf[3] = plane;
		obyte(aedbf,4);
		return;

	default :
		printf(" scp ** invalid cursor type : %d\n", ctype);
		printf(" valid types are L + X\n");
		exit(0);
	} 
}

ejc()				/* enable joystick cursor */
{
	aedbf[0] = EJC;
	obyte(aedbf,1);
}

djc()				/* disable joystick cursor */
{
	aedbf[0] = DJC;
	obyte(aedbf,1);
}

rcp(x,y)	/* read cap  */
int *x,*y;
{
	aedbf[0] = RCP;
	ordcmd(aedbf, 1);
	ibyte(aedbf, 3);

/*	terminal returns x,y packed in 3 bytes -
	first byte is bits 11-8 of x, 11-8 of y,
	next 2 bytes are bits 7-0 x, 7-0 y
*/
	x->hibyte = ( aedbf[0] >> 4 ) &0x0F;
	x->lobyte = aedbf[1];

	y->hibyte = aedbf[0] & 0x0F;
	y->lobyte = aedbf[2];
}

rjp(x,y)	/* Read joystick position */
int *x,*y;
{
	aedbf[0] = RJP;
	ordcmd(aedbf, 1);
	ibyte(aedbf, 3);

/*	see rcp above for returned value format	*/

	x->hibyte = (aedbf[0] >> 4) & 0x0F;
	x->lobyte = aedbf[1];

	y->hibyte = aedbf[0] & 0x0F;
	y->lobyte = aedbf[2];
}

dca(x,y)				/* draw cursor absolute */
int x,y;
{
	encode(aedbf[1],x,y);
	aedbf[0]= DCA;
	obyte(aedbf,4);
}
ecu()				/* erase cursor unconditionally */
{
	aedbf[0]= ECU;
	obyte(aedbf,1);
}
sac(color)			/* set alpha cursor color */
int color;
{
	aedbf[0]= SAC;
	aedbf[1]=color;
	obyte(aedbf,2);
}
